"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.evaluate = void 0;
const json_logic_js_1 = require("json-logic-js");
const semver = __importStar(require("semver"));
const LogicParser_1 = require("./LogicParser");
const utils_1 = require("./utils");
// wotan-disable delete-only-optional-property
json_logic_js_1.add_operation("ver >=", (a, b) => semver.gte(utils_1.padVersion(a), utils_1.padVersion(b)));
json_logic_js_1.add_operation("ver >", (a, b) => semver.gt(utils_1.padVersion(a), utils_1.padVersion(b)));
json_logic_js_1.add_operation("ver <=", (a, b) => semver.lte(utils_1.padVersion(a), utils_1.padVersion(b)));
json_logic_js_1.add_operation("ver <", (a, b) => semver.lt(utils_1.padVersion(a), utils_1.padVersion(b)));
json_logic_js_1.add_operation("ver ===", (a, b) => semver.eq(utils_1.padVersion(a), utils_1.padVersion(b)));
function parseLogic(logic) {
    return LogicParser_1.parse(logic);
}
function evaluate(logic, context) {
    const rules = parseLogic(logic);
    return json_logic_js_1.apply(rules, context);
}
exports.evaluate = evaluate;
//# sourceMappingURL=Logic.js.map