"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.padVersion = exports.getDeviceEntryPredicate = exports.throwInvalidConfig = exports.hexKeyRegex2Digits = exports.hexKeyRegex4Digits = exports.hexKeyRegexNDigits = exports.configDir = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const path_1 = __importDefault(require("path"));
const semver = __importStar(require("semver"));
exports.configDir = path_1.default.resolve(__dirname, "../config");
exports.hexKeyRegexNDigits = /^0x[a-fA-F0-9]+$/;
exports.hexKeyRegex4Digits = /^0x[a-fA-F0-9]{4}$/;
exports.hexKeyRegex2Digits = /^0x[a-fA-F0-9]{2}$/;
function throwInvalidConfig(which, reason) {
    throw new core_1.ZWaveError(`The ${which ? which + " " : ""}config file is malformed!` +
        (reason ? `\n${reason}` : ""), core_1.ZWaveErrorCodes.Config_Invalid);
}
exports.throwInvalidConfig = throwInvalidConfig;
function getDeviceEntryPredicate(manufacturerId, productType, productId, firmwareVersion) {
    return (entry) => {
        if (entry.manufacturerId !== shared_1.formatId(manufacturerId))
            return false;
        if (entry.productType !== shared_1.formatId(productType))
            return false;
        if (entry.productId !== shared_1.formatId(productId))
            return false;
        if (firmwareVersion != undefined) {
            // A firmware version was given, only look at files with a matching firmware version
            return (semver.lte(padVersion(entry.firmwareVersion.min), padVersion(firmwareVersion)) &&
                semver.gte(padVersion(entry.firmwareVersion.max), padVersion(firmwareVersion)));
        }
        return true;
    };
}
exports.getDeviceEntryPredicate = getDeviceEntryPredicate;
/** Pads a firmware version string, so it can be compared with semver */
function padVersion(version) {
    return version + ".0";
}
exports.padVersion = padVersion;
//# sourceMappingURL=utils.js.map