"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseNodeInformationFrame = exports.parseCCList = exports.parseCCId = exports.parseNodeUpdatePayload = void 0;
const misc_1 = require("../util/misc");
const CommandClasses_1 = require("./CommandClasses");
function parseNodeUpdatePayload(nif) {
    return {
        nodeId: nif[0],
        // length is byte 1
        basic: nif[2],
        ...internalParseNodeInformationFrame(nif.slice(3)),
    };
}
exports.parseNodeUpdatePayload = parseNodeUpdatePayload;
function internalParseNodeInformationFrame(nif) {
    misc_1.validatePayload(nif.length >= 2);
    return {
        generic: nif[0],
        specific: nif[1],
        ...parseCCList(nif.slice(2)),
    };
}
/**
 * Reads a CC id from the given buffer, returning the parsed CC id and the number of bytes read
 * @param offset The offset at which the CC id is located
 */
function parseCCId(payload, offset = 0) {
    const isExtended = payload[offset] >= 0xf1;
    misc_1.validatePayload(payload.length >= offset + (isExtended ? 2 : 1));
    if (isExtended) {
        return { ccId: payload.readUInt16BE(offset), bytesRead: 2 };
    }
    else {
        return { ccId: payload.readUInt8(offset), bytesRead: 1 };
    }
}
exports.parseCCId = parseCCId;
function parseCCList(payload) {
    const ret = {
        supportedCCs: [],
        controlledCCs: [],
    };
    let offset = 0;
    let isAfterMark = false;
    while (offset < payload.length) {
        // Read either the normal or extended ccId
        const { ccId: cc, bytesRead } = parseCCId(payload, offset);
        offset += bytesRead;
        // CCs before the support/control mark are supported
        // CCs after the support/control mark are controlled
        if (cc === CommandClasses_1.CommandClasses["Support/Control Mark"]) {
            isAfterMark = true;
            continue;
        }
        (isAfterMark ? ret.controlledCCs : ret.supportedCCs).push(cc);
    }
    return ret;
}
exports.parseCCList = parseCCList;
function parseNodeInformationFrame(nif) {
    const { controlledCCs, ...ret } = internalParseNodeInformationFrame(nif);
    return ret;
}
exports.parseNodeInformationFrame = parseNodeInformationFrame;
//# sourceMappingURL=NodeInfo.js.map