/// <reference types="node" />
declare type Brand<K, T> = K & {
    __brand: T;
};
declare type BrandedUnknown<T> = Brand<"unknown", T>;
export declare type Maybe<T> = T | BrandedUnknown<T>;
export declare const unknownNumber: Maybe<number>;
export declare const unknownBoolean: Maybe<boolean>;
/** Parses a boolean that is encoded as a single byte and might also be "unknown" */
export declare function parseMaybeBoolean(val: number, preserveUnknown?: boolean): Maybe<boolean> | undefined;
/** Parses a boolean that is encoded as a single byte */
export declare function parseBoolean(val: number): boolean | undefined;
/** Parses a single-byte number from 0 to 100, which might also be "unknown" */
export declare function parseMaybeNumber(val: number, preserveUnknown?: boolean): Maybe<number> | undefined;
/** Parses a single-byte number from 0 to 100 */
export declare function parseNumber(val: number): number | undefined;
/** Parses a floating point value with a scale from a buffer */
export declare function parseFloatWithScale(payload: Buffer): {
    value: number;
    scale: number;
    bytesRead: number;
};
/** The minimum and maximum values that can be stored in each numeric value type */
export declare const IntegerLimits: Readonly<{
    UInt8: Readonly<{
        min: number;
        max: number;
    }>;
    UInt16: Readonly<{
        min: number;
        max: number;
    }>;
    UInt24: Readonly<{
        min: number;
        max: number;
    }>;
    UInt32: Readonly<{
        min: number;
        max: number;
    }>;
    Int8: Readonly<{
        min: number;
        max: number;
    }>;
    Int16: Readonly<{
        min: number;
        max: number;
    }>;
    Int24: Readonly<{
        min: number;
        max: number;
    }>;
    Int32: Readonly<{
        min: number;
        max: number;
    }>;
}>;
export declare function getMinIntegerSize(value: number, signed: boolean): 1 | 2 | 4 | undefined;
export declare function getIntegerLimits(size: 1 | 2 | 3 | 4, signed: boolean): {
    min: number;
    max: number;
};
/**
 * Encodes a floating point value with a scale into a buffer
 * @param override can be used to overwrite the automatic computation of precision and size with fixed values
 */
export declare function encodeFloatWithScale(value: number, scale: number, override?: {
    size?: number;
    precision?: number;
}): Buffer;
/** Parses a bit mask into a numeric array */
export declare function parseBitMask(mask: Buffer, startValue?: number): number[];
/** Serializes a numeric array with a given maximum into a bit mask */
export declare function encodeBitMask(values: number[], maxValue: number): Buffer;
export {};
//# sourceMappingURL=Primitive.d.ts.map