"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareStrings = exports.isPrintableASCIIWithNewlines = exports.isPrintableASCII = exports.buffer2hex = exports.stringify = exports.formatId = exports.num2hex = exports.cpp2js = void 0;
const strings_1 = require("alcalzone-shared/strings");
/** Translates a null-terminated (C++) string to JS */
function cpp2js(str) {
    const nullIndex = str.indexOf("\0");
    if (nullIndex === -1)
        return str;
    return str.substr(0, nullIndex);
}
exports.cpp2js = cpp2js;
function num2hex(val, uppercase = false) {
    if (val == null)
        return "undefined";
    let ret = val.toString(16);
    if (uppercase)
        ret = ret.toUpperCase();
    if (ret.length % 2 !== 0)
        ret = "0" + ret;
    return "0x" + ret;
}
exports.num2hex = num2hex;
function formatId(id) {
    id = typeof id === "number" ? id.toString(16) : id;
    return "0x" + strings_1.padStart(id, 4, "0").toLowerCase();
}
exports.formatId = formatId;
function stringify(arg, space = 4) {
    return JSON.stringify(arg, null, space);
}
exports.stringify = stringify;
function buffer2hex(buffer, uppercase = false) {
    if (buffer.length === 0)
        return "(empty)";
    let ret = `0x${buffer.toString("hex")}`;
    if (uppercase)
        ret = ret.toUpperCase();
    return ret;
}
exports.buffer2hex = buffer2hex;
function isPrintableASCII(text) {
    return /^[\u0020-\u007e]*$/.test(text);
}
exports.isPrintableASCII = isPrintableASCII;
function isPrintableASCIIWithNewlines(text) {
    return /^[\r\n]*[\u0020-\u007e]*[\r\n]*$/.test(text);
}
exports.isPrintableASCIIWithNewlines = isPrintableASCIIWithNewlines;
function compareStrings(a, b) {
    if (a > b)
        return 1;
    if (b > a)
        return -1;
    return 0;
}
exports.compareStrings = compareStrings;
//# sourceMappingURL=strings.js.map