"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasicCCGet = exports.BasicCCReport = exports.BasicCCSet = exports.BasicCC = exports.BasicCCAPI = exports.getCompatEventValueId = exports.getCurrentValueValueId = exports.getTargetValueValueId = exports.BasicCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
var BasicCommand;
(function (BasicCommand) {
    BasicCommand[BasicCommand["Set"] = 1] = "Set";
    BasicCommand[BasicCommand["Get"] = 2] = "Get";
    BasicCommand[BasicCommand["Report"] = 3] = "Report";
})(BasicCommand = exports.BasicCommand || (exports.BasicCommand = {}));
function getTargetValueValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses.Basic,
        endpoint,
        property: "targetValue",
    };
}
exports.getTargetValueValueId = getTargetValueValueId;
function getCurrentValueValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses.Basic,
        endpoint,
        property: "currentValue",
    };
}
exports.getCurrentValueValueId = getCurrentValueValueId;
function getCompatEventValueId(endpoint) {
    return {
        commandClass: core_1.CommandClasses.Basic,
        endpoint,
        property: "event",
    };
}
exports.getCompatEventValueId = getCompatEventValueId;
let BasicCCAPI = class BasicCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property }, value) => {
            var _c;
            if (property !== "targetValue") {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
            if (typeof value !== "number") {
                API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
            }
            await this.set(value);
            // If the command did not fail, assume that it succeeded and update the currentValue accordingly
            // so UIs have immediate feedback
            if (this.isSinglecast()) {
                // Only update currentValue for valid target values
                if (value >= 0 && value <= 99) {
                    const valueDB = (_c = this.endpoint.getNodeUnsafe()) === null || _c === void 0 ? void 0 : _c.valueDB;
                    valueDB === null || valueDB === void 0 ? void 0 : valueDB.setValue(getCurrentValueValueId(this.endpoint.index), value);
                }
                // and verify the current value after a delay
                this.schedulePoll({ property });
            }
        };
        this[_b] = async ({ property, }) => {
            var _c;
            switch (property) {
                case "currentValue":
                case "targetValue":
                case "duration":
                    return (_c = (await this.get())) === null || _c === void 0 ? void 0 : _c[property];
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case BasicCommand.Get:
                return this.isSinglecast();
            case BasicCommand.Set:
                return true;
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
        this.assertSupportsCommand(BasicCommand, BasicCommand.Get);
        const cc = new BasicCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["currentValue", "targetValue", "duration"]);
        }
    }
    async set(targetValue) {
        this.assertSupportsCommand(BasicCommand, BasicCommand.Set);
        const cc = new BasicCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            targetValue,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
BasicCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses.Basic)
], BasicCCAPI);
exports.BasicCCAPI = BasicCCAPI;
let BasicCC = class BasicCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        var _c, _d, _e, _f;
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses.Basic.withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        // try to query the current state
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "querying Basic CC state...",
            direction: "outbound",
        });
        const basicResponse = await api.get();
        if (basicResponse) {
            let logMessage = `received Basic CC state:
current value:      ${basicResponse.currentValue}`;
            if (basicResponse.targetValue != undefined) {
                logMessage += `
target value:       ${basicResponse.targetValue}
remaining duration: ${(_d = (_c = basicResponse.duration) === null || _c === void 0 ? void 0 : _c.toString()) !== null && _d !== void 0 ? _d : "undefined"}`;
            }
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: logMessage,
                direction: "inbound",
            });
        }
        else {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "No response to Basic Get command, assuming the node does not support Basic CC...",
            });
            // SDS14223: A controlling node MUST conclude that the Basic Command Class is not supported by a node (or
            // endpoint) if no Basic Report is returned.
            endpoint.removeCC(core_1.CommandClasses.Basic);
        }
        // create compat event value if necessary
        if ((_f = (_e = node.deviceConfig) === null || _e === void 0 ? void 0 : _e.compat) === null || _f === void 0 ? void 0 : _f.treatBasicSetAsEvent) {
            const valueId = getCompatEventValueId(this.endpointIndex);
            if (!node.valueDB.hasMetadata(valueId)) {
                node.valueDB.setMetadata(valueId, {
                    ...core_1.ValueMetadata.ReadOnlyUInt8,
                    label: "Event value",
                });
            }
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
BasicCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses.Basic),
    CommandClass_1.implementedVersion(2) // Update tests in CommandClass.test.ts when changing this
], BasicCC);
exports.BasicCC = BasicCC;
let BasicCCSet = class BasicCCSet extends BasicCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            core_1.validatePayload(this.payload.length >= 1);
            this.targetValue = this.payload[0];
        }
        else {
            this.targetValue = options.targetValue;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.targetValue]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "target value": this.targetValue },
        };
    }
};
BasicCCSet = __decorate([
    CommandClass_1.CCCommand(BasicCommand.Set)
], BasicCCSet);
exports.BasicCCSet = BasicCCSet;
let BasicCCReport = class BasicCCReport extends BasicCC {
    // @noCCValues See comment in the constructor
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            core_1.validatePayload(this.payload.length >= 1);
            this.currentValue = core_1.parseMaybeNumber(this.payload[0], driver.options.preserveUnknownValues);
            if (this.version >= 2 && this.payload.length >= 3) {
                this.targetValue = core_1.parseNumber(this.payload[1]);
                this.duration = core_1.Duration.parseReport(this.payload[2]);
            }
            // Do not persist values here. We want to control when this is happening,
            // in case the report is mapped to another CC
        }
        else {
            this.currentValue = options.currentValue;
            if ("targetValue" in options) {
                this.targetValue = options.targetValue;
                this.duration = options.duration;
            }
        }
    }
    serialize() {
        const payload = [
            typeof this.currentValue !== "number" ? 0xfe : this.currentValue,
        ];
        if (this.version >= 2 && this.targetValue && this.duration) {
            payload.push(this.targetValue, this.duration.serializeReport());
        }
        this.payload = Buffer.from(payload);
        return super.serialize();
    }
    toLogEntry() {
        const message = {
            "current value": this.currentValue,
        };
        if (this.targetValue != undefined) {
            message["target value"] = this.targetValue;
        }
        if (this.duration != undefined) {
            message.duration = this.duration.toString();
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyLevel,
        label: "Current value",
    })
], BasicCCReport.prototype, "currentValue", void 0);
__decorate([
    CommandClass_1.ccValue({ forceCreation: true }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Level,
        label: "Target value",
    })
], BasicCCReport.prototype, "targetValue", void 0);
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyDuration,
        label: "Remaining duration until target value",
    })
], BasicCCReport.prototype, "duration", void 0);
BasicCCReport = __decorate([
    CommandClass_1.CCCommand(BasicCommand.Report)
], BasicCCReport);
exports.BasicCCReport = BasicCCReport;
let BasicCCGet = class BasicCCGet extends BasicCC {
};
BasicCCGet = __decorate([
    CommandClass_1.CCCommand(BasicCommand.Get),
    CommandClass_1.expectedCCResponse(BasicCCReport)
], BasicCCGet);
exports.BasicCCGet = BasicCCGet;

//# sourceMappingURL=BasicCC.js.map
