import type { MessageOrCCLogEntry } from "@zwave-js/core";
import { Maybe } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { PhysicalCCAPI, PollValueImplementation, POLL_VALUE } from "./API";
import { CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
/**
 * @publicAPI
 */
export declare enum BatteryChargingStatus {
    Discharging = 0,
    Charging = 1,
    Maintaining = 2
}
/**
 * @publicAPI
 */
export declare enum BatteryReplacementStatus {
    No = 0,
    Soon = 1,
    Now = 2
}
export declare enum BatteryCommand {
    Get = 2,
    Report = 3,
    HealthGet = 4,
    HealthReport = 5
}
export declare class BatteryCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: BatteryCommand): Maybe<boolean>;
    protected [POLL_VALUE]: PollValueImplementation;
    get(): Promise<Pick<BatteryCCReport, "level" | "isLow" | "chargingStatus" | "rechargeable" | "backup" | "overheating" | "lowFluid" | "rechargeOrReplace" | "lowTemperatureStatus" | "disconnected"> | undefined>;
    getHealth(): Promise<Pick<BatteryCCHealthReport, "maximumCapacity" | "temperature"> | undefined>;
}
export declare class BatteryCC extends CommandClass {
    ccCommand: BatteryCommand;
    interview(complete?: boolean): Promise<void>;
}
export declare class BatteryCCReport extends BatteryCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _level;
    get level(): number;
    private _isLow;
    get isLow(): boolean;
    private _chargingStatus;
    get chargingStatus(): BatteryChargingStatus | undefined;
    private _rechargeable;
    get rechargeable(): boolean | undefined;
    private _backup;
    get backup(): boolean | undefined;
    private _overheating;
    get overheating(): boolean | undefined;
    private _lowFluid;
    get lowFluid(): boolean | undefined;
    private _rechargeOrReplace;
    get rechargeOrReplace(): BatteryReplacementStatus | undefined;
    private _disconnected;
    get disconnected(): boolean | undefined;
    private _lowTemperatureStatus;
    get lowTemperatureStatus(): boolean | undefined;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class BatteryCCGet extends BatteryCC {
}
export declare class BatteryCCHealthReport extends BatteryCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _maximumCapacity;
    get maximumCapacity(): number;
    private _temperature;
    get temperature(): number;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class BatteryCCHealthGet extends BatteryCC {
}
