/// <reference types="node" />
import { Duration, Maybe, MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI, PollValueImplementation, POLL_VALUE, SetValueImplementation, SET_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions, CommandClassOptions } from "./CommandClass";
import { LevelChangeDirection } from "./MultilevelSwitchCC";
export declare enum ColorSwitchCommand {
    SupportedGet = 1,
    SupportedReport = 2,
    Get = 3,
    Report = 4,
    Set = 5,
    StartLevelChange = 6,
    StopLevelChange = 7
}
/**
 * @publicAPI
 */
export declare enum ColorComponent {
    "Warm White" = 0,
    "Cold White" = 1,
    Red = 2,
    Green = 3,
    Blue = 4,
    Amber = 5,
    Cyan = 6,
    Purple = 7,
    Index = 8
}
declare const ColorComponentMap: {
    warmWhite: ColorComponent;
    coldWhite: ColorComponent;
    red: ColorComponent;
    green: ColorComponent;
    blue: ColorComponent;
    amber: ColorComponent;
    cyan: ColorComponent;
    purple: ColorComponent;
    index: ColorComponent;
};
declare type ColorKey = keyof typeof ColorComponentMap;
/**
 * @publicAPI
 */
export declare type ColorTable = Partial<Record<ColorKey, number>> | Partial<Record<ColorComponent, number>>;
export declare class ColorSwitchCCAPI extends CCAPI {
    supportsCommand(cmd: ColorSwitchCommand): Maybe<boolean>;
    getSupported(): Promise<readonly ColorComponent[] | undefined>;
    get(component: ColorComponent): Promise<Pick<ColorSwitchCCReport, "targetValue" | "currentValue" | "duration"> | undefined>;
    set(options: ColorSwitchCCSetOptions): Promise<void>;
    startLevelChange(options: ColorSwitchCCStartLevelChangeOptions): Promise<void>;
    stopLevelChange(colorComponent: ColorComponent): Promise<void>;
    protected [SET_VALUE]: SetValueImplementation;
    isSetValueOptimistic(_valueId: ValueID): boolean;
    protected [POLL_VALUE]: PollValueImplementation;
}
export declare class ColorSwitchCC extends CommandClass {
    ccCommand: ColorSwitchCommand;
    constructor(driver: Driver, options: CommandClassOptions);
    interview(complete?: boolean): Promise<void>;
    translatePropertyKey(property: string | number, propertyKey: string | number): string | undefined;
}
export declare class ColorSwitchCCSupportedReport extends ColorSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly supportedColorComponents: readonly ColorComponent[];
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class ColorSwitchCCSupportedGet extends ColorSwitchCC {
}
export declare class ColorSwitchCCReport extends ColorSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    persistValues(): boolean;
    readonly colorComponent: ColorComponent;
    readonly currentValue: number;
    readonly targetValue: number | undefined;
    readonly duration: Duration | undefined;
    toLogEntry(): MessageOrCCLogEntry;
}
interface ColorSwitchCCGetOptions extends CCCommandOptions {
    colorComponent: ColorComponent;
}
export declare class ColorSwitchCCGet extends ColorSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ColorSwitchCCGetOptions);
    private _colorComponent;
    get colorComponent(): ColorComponent;
    set colorComponent(value: ColorComponent);
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare type ColorSwitchCCSetOptions = (ColorTable | {
    hexColor: string;
}) & {
    duration?: Duration;
};
export declare class ColorSwitchCCSet extends ColorSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | (CCCommandOptions & ColorSwitchCCSetOptions));
    colorTable: ColorTable;
    duration: Duration | undefined;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
declare type ColorSwitchCCStartLevelChangeOptions = {
    colorComponent: ColorComponent;
    direction: keyof typeof LevelChangeDirection;
} & ({
    ignoreStartLevel: true;
    startLevel?: number;
} | {
    ignoreStartLevel: false;
    startLevel: number;
}) & {
    duration?: Duration;
};
export declare class ColorSwitchCCStartLevelChange extends ColorSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | (CCCommandOptions & ColorSwitchCCStartLevelChangeOptions));
    duration: Duration | undefined;
    startLevel: number;
    ignoreStartLevel: boolean;
    direction: keyof typeof LevelChangeDirection;
    colorComponent: ColorComponent;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export interface ColorSwitchCCStopLevelChangeOptions extends CCCommandOptions {
    colorComponent: ColorComponent;
}
export declare class ColorSwitchCCStopLevelChange extends ColorSwitchCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | ColorSwitchCCStopLevelChangeOptions);
    readonly colorComponent: ColorComponent;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
