/// <reference types="node" />
import type { GenericDeviceClass, SpecificDeviceClass } from "@zwave-js/config";
import { CommandClasses, Maybe, MessageOrCCLogEntry, ValueID } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions, CommandClassOptions } from "./CommandClass";
export declare enum MultiChannelCommand {
    GetV1 = 4,
    ReportV1 = 5,
    CommandEncapsulationV1 = 6,
    EndPointGet = 7,
    EndPointReport = 8,
    CapabilityGet = 9,
    CapabilityReport = 10,
    EndPointFind = 11,
    EndPointFindReport = 12,
    CommandEncapsulation = 13,
    AggregatedMembersGet = 14,
    AggregatedMembersReport = 15
}
export declare function getEndpointCCsValueId(endpointIndex: number): ValueID;
export declare function getCountIsDynamicValueId(): ValueID;
export declare function getIdenticalCapabilitiesValueId(): ValueID;
export declare function getIndividualCountValueId(): ValueID;
export declare function getAggregatedCountValueId(): ValueID;
export declare class MultiChannelCCAPI extends CCAPI {
    supportsCommand(cmd: MultiChannelCommand): Maybe<boolean>;
    getEndpoints(): Promise<{
        isDynamicEndpointCount: boolean;
        identicalCapabilities: boolean;
        individualEndpointCount: number;
        aggregatedEndpointCount: number | undefined;
    } | undefined>;
    getEndpointCapabilities(endpoint: number): Promise<EndpointCapability | undefined>;
    findEndpoints(genericClass: number, specificClass: number): Promise<readonly number[] | undefined>;
    getAggregatedMembers(endpoint: number): Promise<readonly number[] | undefined>;
    sendEncapsulated(options: Omit<MultiChannelCCCommandEncapsulationOptions, keyof CCCommandOptions>): Promise<void>;
    getEndpointCountV1(ccId: CommandClasses): Promise<number | undefined>;
    sendEncapsulatedV1(encapsulated: CommandClass): Promise<void>;
}
export interface EndpointCapability {
    generic: GenericDeviceClass;
    specific: SpecificDeviceClass;
    supportedCCs: CommandClasses[];
    isDynamic: boolean;
    wasRemoved: boolean;
}
export declare class MultiChannelCC extends CommandClass {
    ccCommand: MultiChannelCommand;
    constructor(driver: Driver, options: CommandClassOptions);
    /** Tests if a command targets a specific endpoint and thus requires encapsulation */
    static requiresEncapsulation(cc: CommandClass): boolean;
    /** Encapsulates a command that targets a specific endpoint */
    static encapsulate(driver: Driver, cc: CommandClass): MultiChannelCCCommandEncapsulation;
    interview(complete?: boolean): Promise<void>;
    private interviewV1;
}
export declare class MultiChannelCCEndPointReport extends MultiChannelCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _countIsDynamic;
    get countIsDynamic(): boolean;
    private _identicalCapabilities;
    get identicalCapabilities(): boolean;
    private _individualCount;
    get individualCount(): number;
    private _aggregatedCount;
    get aggregatedCount(): number | undefined;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class MultiChannelCCEndPointGet extends MultiChannelCC {
}
export declare class MultiChannelCCCapabilityReport extends MultiChannelCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    persistValues(): boolean;
    readonly endpointIndex: number;
    readonly capability: EndpointCapability;
    toLogEntry(): MessageOrCCLogEntry;
}
interface MultiChannelCCCapabilityGetOptions extends CCCommandOptions {
    requestedEndpoint: number;
}
export declare class MultiChannelCCCapabilityGet extends MultiChannelCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | MultiChannelCCCapabilityGetOptions);
    requestedEndpoint: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class MultiChannelCCEndPointFindReport extends MultiChannelCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _genericClass;
    get genericClass(): number;
    private _specificClass;
    get specificClass(): number;
    private _foundEndpoints;
    get foundEndpoints(): readonly number[];
    private _reportsToFollow;
    get reportsToFollow(): number;
    getPartialCCSessionId(): Record<string, any> | undefined;
    expectMoreMessages(): boolean;
    mergePartialCCs(partials: MultiChannelCCEndPointFindReport[]): void;
    toLogEntry(): MessageOrCCLogEntry;
}
interface MultiChannelCCEndPointFindOptions extends CCCommandOptions {
    genericClass: number;
    specificClass: number;
}
export declare class MultiChannelCCEndPointFind extends MultiChannelCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | MultiChannelCCEndPointFindOptions);
    genericClass: number;
    specificClass: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class MultiChannelCCAggregatedMembersReport extends MultiChannelCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private aggregatedEndpointMembers;
    get aggregatedEndpoint(): number;
    get members(): readonly number[];
    toLogEntry(): MessageOrCCLogEntry;
}
interface MultiChannelCCAggregatedMembersGetOptions extends CCCommandOptions {
    requestedEndpoint: number;
}
export declare class MultiChannelCCAggregatedMembersGet extends MultiChannelCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | MultiChannelCCAggregatedMembersGetOptions);
    requestedEndpoint: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
declare type MultiChannelCCDestination = number | (1 | 2 | 3 | 4 | 5 | 6 | 7)[];
interface MultiChannelCCCommandEncapsulationOptions extends CCCommandOptions {
    encapsulated: CommandClass;
    destination: MultiChannelCCDestination;
}
export declare class MultiChannelCCCommandEncapsulation extends MultiChannelCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | MultiChannelCCCommandEncapsulationOptions);
    encapsulated: CommandClass;
    /** The destination end point (0-127) or an array of destination end points (1-7) */
    destination: MultiChannelCCDestination;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
    protected computeEncapsulationOverhead(): number;
}
export declare class MultiChannelCCV1Report extends MultiChannelCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly requestedCC: CommandClasses;
    readonly endpointCount: number;
    toLogEntry(): MessageOrCCLogEntry;
}
interface MultiChannelCCV1GetOptions extends CCCommandOptions {
    requestedCC: CommandClasses;
}
export declare class MultiChannelCCV1Get extends MultiChannelCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | MultiChannelCCV1GetOptions);
    requestedCC: CommandClasses;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
interface MultiChannelCCV1CommandEncapsulationOptions extends CCCommandOptions {
    encapsulated: CommandClass;
}
export declare class MultiChannelCCV1CommandEncapsulation extends MultiChannelCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | MultiChannelCCV1CommandEncapsulationOptions);
    encapsulated: CommandClass;
    serialize(): Buffer;
    protected computeEncapsulationOverhead(): number;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
