/// <reference types="node" />
import { Scale } from "@zwave-js/config";
import type { MessageOrCCLogEntry } from "@zwave-js/core";
import { Maybe, ValueMetadata } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { PhysicalCCAPI, PollValueImplementation, POLL_VALUE } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum MultilevelSensorCommand {
    GetSupportedSensor = 1,
    SupportedSensorReport = 2,
    GetSupportedScale = 3,
    Get = 4,
    Report = 5,
    SupportedScaleReport = 6
}
/**
 * @publicAPI
 */
export interface MultilevelSensorValue {
    value: number;
    scale: Scale;
}
/**
 * @publicAPI
 */
export declare type MultilevelSensorValueMetadata = ValueMetadata & {
    ccSpecific: {
        sensorType: number;
        scale: number;
    };
};
export declare class MultilevelSensorCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: MultilevelSensorCommand): Maybe<boolean>;
    protected [POLL_VALUE]: PollValueImplementation;
    get(): Promise<(MultilevelSensorValue & {
        type: number;
    }) | undefined>;
    get(sensorType: number, scale: number): Promise<number | undefined>;
    getSupportedSensorTypes(): Promise<readonly number[] | undefined>;
    getSupportedScales(sensorType: number): Promise<readonly number[] | undefined>;
    sendReport(sensorType: number, scale: number | Scale, value: number): Promise<void>;
}
export declare class MultilevelSensorCC extends CommandClass {
    ccCommand: MultilevelSensorCommand;
    interview(complete?: boolean): Promise<void>;
    translatePropertyKey(property: string | number, propertyKey: string | number): string | undefined;
}
export interface MultilevelSensorCCReportOptions extends CCCommandOptions {
    type: number;
    scale: number | Scale;
    value: number;
}
export declare class MultilevelSensorCCReport extends MultilevelSensorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | MultilevelSensorCCReportOptions);
    persistValues(): boolean;
    type: number;
    scale: Scale;
    value: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
interface MultilevelSensorCCGetSpecificOptions {
    sensorType: number;
    scale: number;
}
declare type MultilevelSensorCCGetOptions = CCCommandOptions | (CCCommandOptions & MultilevelSensorCCGetSpecificOptions);
export declare class MultilevelSensorCCGet extends MultilevelSensorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | MultilevelSensorCCGetOptions);
    sensorType: number | undefined;
    scale: number | undefined;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class MultilevelSensorCCSupportedSensorReport extends MultilevelSensorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _supportedSensorTypes;
    get supportedSensorTypes(): readonly number[];
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class MultilevelSensorCCGetSupportedSensor extends MultilevelSensorCC {
}
export declare class MultilevelSensorCCSupportedScaleReport extends MultilevelSensorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private supportedScales;
    get sensorType(): number;
    get sensorSupportedScales(): readonly number[];
    toLogEntry(): MessageOrCCLogEntry;
}
interface MultilevelSensorCCGetSupportedScaleOptions extends CCCommandOptions {
    sensorType: number;
}
export declare class MultilevelSensorCCGetSupportedScale extends MultilevelSensorCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | MultilevelSensorCCGetSupportedScaleOptions);
    sensorType: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
