"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProtectionCCTimeoutSet = exports.ProtectionCCTimeoutGet = exports.ProtectionCCTimeoutReport = exports.ProtectionCCExclusiveControlSet = exports.ProtectionCCExclusiveControlGet = exports.ProtectionCCExclusiveControlReport = exports.ProtectionCCSupportedGet = exports.ProtectionCCSupportedReport = exports.ProtectionCCGet = exports.ProtectionCCReport = exports.ProtectionCCSet = exports.ProtectionCC = exports.ProtectionCCAPI = exports.getSupportsTimeoutValueID = exports.getSupportsExclusiveControlValueID = exports.getTimeoutValueID = exports.getRFStateValueID = exports.getLocalStateValueID = exports.getExclusiveControlNodeIdValueID = exports.RFProtectionState = exports.LocalProtectionState = exports.ProtectionCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const strings_1 = require("alcalzone-shared/strings");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// All the supported commands
var ProtectionCommand;
(function (ProtectionCommand) {
    ProtectionCommand[ProtectionCommand["Set"] = 1] = "Set";
    ProtectionCommand[ProtectionCommand["Get"] = 2] = "Get";
    ProtectionCommand[ProtectionCommand["Report"] = 3] = "Report";
    ProtectionCommand[ProtectionCommand["SupportedGet"] = 4] = "SupportedGet";
    ProtectionCommand[ProtectionCommand["SupportedReport"] = 5] = "SupportedReport";
    ProtectionCommand[ProtectionCommand["ExclusiveControlSet"] = 6] = "ExclusiveControlSet";
    ProtectionCommand[ProtectionCommand["ExclusiveControlGet"] = 7] = "ExclusiveControlGet";
    ProtectionCommand[ProtectionCommand["ExclusiveControlReport"] = 8] = "ExclusiveControlReport";
    ProtectionCommand[ProtectionCommand["TimeoutSet"] = 9] = "TimeoutSet";
    ProtectionCommand[ProtectionCommand["TimeoutGet"] = 10] = "TimeoutGet";
    ProtectionCommand[ProtectionCommand["TimeoutReport"] = 11] = "TimeoutReport";
})(ProtectionCommand = exports.ProtectionCommand || (exports.ProtectionCommand = {}));
// @publicAPI
var LocalProtectionState;
(function (LocalProtectionState) {
    LocalProtectionState[LocalProtectionState["Unprotected"] = 0] = "Unprotected";
    LocalProtectionState[LocalProtectionState["ProtectedBySequence"] = 1] = "ProtectedBySequence";
    LocalProtectionState[LocalProtectionState["NoOperationPossible"] = 2] = "NoOperationPossible";
})(LocalProtectionState = exports.LocalProtectionState || (exports.LocalProtectionState = {}));
// @publicAPI
var RFProtectionState;
(function (RFProtectionState) {
    RFProtectionState[RFProtectionState["Unprotected"] = 0] = "Unprotected";
    RFProtectionState[RFProtectionState["NoControl"] = 1] = "NoControl";
    RFProtectionState[RFProtectionState["NoResponse"] = 2] = "NoResponse";
})(RFProtectionState = exports.RFProtectionState || (exports.RFProtectionState = {}));
function getExclusiveControlNodeIdValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses.Protection,
        endpoint,
        property: "exclusiveControlNodeId",
    };
}
exports.getExclusiveControlNodeIdValueID = getExclusiveControlNodeIdValueID;
function getLocalStateValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses.Protection,
        endpoint,
        property: "local",
    };
}
exports.getLocalStateValueID = getLocalStateValueID;
function getRFStateValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses.Protection,
        endpoint,
        property: "rf",
    };
}
exports.getRFStateValueID = getRFStateValueID;
function getTimeoutValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses.Protection,
        endpoint,
        property: "timeout",
    };
}
exports.getTimeoutValueID = getTimeoutValueID;
function getSupportsExclusiveControlValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses.Protection,
        endpoint,
        property: "supportsExclusiveControl",
    };
}
exports.getSupportsExclusiveControlValueID = getSupportsExclusiveControlValueID;
function getSupportsTimeoutValueID(endpoint) {
    return {
        commandClass: core_1.CommandClasses.Protection,
        endpoint,
        property: "supportsTimeout",
    };
}
exports.getSupportsTimeoutValueID = getSupportsTimeoutValueID;
let ProtectionCCAPI = class ProtectionCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property }, value) => {
            const valueDB = this.endpoint.getNodeUnsafe().valueDB;
            if (property === "local") {
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                // We need to set both values together, so retrieve the other one from the value DB
                const rf = valueDB.getValue(getRFStateValueID(this.endpoint.index));
                await this.set(value, rf);
            }
            else if (property === "rf") {
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                // We need to set both values together, so retrieve the other one from the value DB
                const local = valueDB.getValue(getLocalStateValueID(this.endpoint.index));
                await this.set(local !== null && local !== void 0 ? local : LocalProtectionState.Unprotected, value);
            }
            else if (property === "exclusiveControlNodeId") {
                if (typeof value !== "number") {
                    API_1.throwWrongValueType(this.ccId, property, "number", typeof value);
                }
                await this.setExclusiveControl(value);
            }
            else {
                API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
        this[_b] = async ({ property, }) => {
            var _c;
            switch (property) {
                case "local":
                case "rf":
                    return (_c = (await this.get())) === null || _c === void 0 ? void 0 : _c[property];
                case "exclusiveControlNodeId":
                    return this.getExclusiveControl();
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        var _c, _d;
        switch (cmd) {
            case ProtectionCommand.Get:
                return this.isSinglecast();
            case ProtectionCommand.Set:
                return true; // This is mandatory
            case ProtectionCommand.SupportedGet:
                return this.version >= 2 && this.isSinglecast();
            case ProtectionCommand.TimeoutGet:
            case ProtectionCommand.TimeoutSet: {
                const node = this.endpoint.getNodeUnsafe();
                return (this.isSinglecast() &&
                    ((_c = node.getValue(getSupportsTimeoutValueID(this.endpoint.index))) !== null && _c !== void 0 ? _c : core_1.unknownBoolean));
            }
            case ProtectionCommand.ExclusiveControlGet:
            case ProtectionCommand.ExclusiveControlSet: {
                const node = this.endpoint.getNodeUnsafe();
                return (this.isSinglecast() &&
                    ((_d = node.getValue(getSupportsExclusiveControlValueID(this.endpoint.index))) !== null && _d !== void 0 ? _d : core_1.unknownBoolean));
            }
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
        this.assertSupportsCommand(ProtectionCommand, ProtectionCommand.Get);
        const cc = new ProtectionCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, ["local", "rf"]);
        }
    }
    async set(local, rf) {
        this.assertSupportsCommand(ProtectionCommand, ProtectionCommand.Set);
        const cc = new ProtectionCCSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            local,
            rf,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getSupported() {
        this.assertSupportsCommand(ProtectionCommand, ProtectionCommand.SupportedGet);
        const cc = new ProtectionCCSupportedGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return shared_1.pick(response, [
                "supportsExclusiveControl",
                "supportsTimeout",
                "supportedLocalStates",
                "supportedRFStates",
            ]);
        }
    }
    async getExclusiveControl() {
        this.assertSupportsCommand(ProtectionCommand, ProtectionCommand.ExclusiveControlGet);
        const cc = new ProtectionCCExclusiveControlGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.exclusiveControlNodeId;
    }
    async setExclusiveControl(nodeId) {
        this.assertSupportsCommand(ProtectionCommand, ProtectionCommand.ExclusiveControlSet);
        const cc = new ProtectionCCExclusiveControlSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            exclusiveControlNodeId: nodeId,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
    async getTimeout() {
        this.assertSupportsCommand(ProtectionCommand, ProtectionCommand.TimeoutGet);
        const cc = new ProtectionCCTimeoutGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        return response === null || response === void 0 ? void 0 : response.timeout;
    }
    async setTimeout(timeout) {
        this.assertSupportsCommand(ProtectionCommand, ProtectionCommand.TimeoutSet);
        const cc = new ProtectionCCTimeoutSet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
            timeout,
        });
        await this.driver.sendCommand(cc, this.commandOptions);
    }
};
_a = API_1.SET_VALUE, _b = API_1.POLL_VALUE;
ProtectionCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses.Protection)
], ProtectionCCAPI);
exports.ProtectionCCAPI = ProtectionCCAPI;
let ProtectionCC = class ProtectionCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses.Protection.withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        const valueDB = this.getValueDB();
        // We need to do some queries after a potential timeout
        // In this case, do now mark this CC as interviewed completely
        let hadCriticalTimeout = false;
        // First find out what the device supports
        if (complete && this.version >= 2) {
            this.driver.controllerLog.logNode(node.id, {
                message: "querying protection capabilities...",
                direction: "outbound",
            });
            const resp = await api.getSupported();
            if (resp) {
                const logMessage = `received protection capabilities:
exclusive control:       ${resp.supportsExclusiveControl}
timeout:                 ${resp.supportsTimeout}
local protection states: ${resp.supportedLocalStates
                    .map((local) => shared_1.getEnumMemberName(LocalProtectionState, local))
                    .map((str) => `\n· ${str}`)
                    .join("")}
RF protection states:    ${resp.supportedRFStates
                    .map((local) => shared_1.getEnumMemberName(RFProtectionState, local))
                    .map((str) => `\n· ${str}`)
                    .join("")}`;
                this.driver.controllerLog.logNode(node.id, {
                    message: logMessage,
                    direction: "inbound",
                });
            }
            else {
                hadCriticalTimeout = true;
            }
        }
        const supportsExclusiveControl = !!valueDB.getValue(getSupportsExclusiveControlValueID(this.endpointIndex));
        const supportsTimeout = !!valueDB.getValue(getSupportsTimeoutValueID(this.endpointIndex));
        // Query the current state
        this.driver.controllerLog.logNode(node.id, {
            message: "querying protection status...",
            direction: "outbound",
        });
        const protectionResp = await api.get();
        if (protectionResp) {
            let logMessage = `received protection status:
local: ${shared_1.getEnumMemberName(LocalProtectionState, protectionResp.local)}`;
            if (protectionResp.rf != undefined) {
                logMessage += `
rf     ${shared_1.getEnumMemberName(RFProtectionState, protectionResp.rf)}`;
            }
            this.driver.controllerLog.logNode(node.id, {
                message: logMessage,
                direction: "inbound",
            });
        }
        if (supportsTimeout) {
            // Query the current timeout
            this.driver.controllerLog.logNode(node.id, {
                message: "querying protection timeout...",
                direction: "outbound",
            });
            const timeout = await api.getTimeout();
            if (timeout) {
                this.driver.controllerLog.logNode(node.id, {
                    message: `received timeout: ${timeout.toString()}`,
                    direction: "inbound",
                });
            }
        }
        if (supportsExclusiveControl) {
            // Query the current timeout
            this.driver.controllerLog.logNode(node.id, {
                message: "querying exclusive control node...",
                direction: "outbound",
            });
            const nodeId = await api.getExclusiveControl();
            if (nodeId != undefined) {
                this.driver.controllerLog.logNode(node.id, {
                    message: (nodeId !== 0
                        ? `Node ${strings_1.padStart(nodeId.toString(), 3, "0")}`
                        : `no node`) + ` has exclusive control`,
                    direction: "inbound",
                });
            }
        }
        // Remember that the interview is complete
        if (!hadCriticalTimeout)
            this.interviewComplete = true;
    }
};
ProtectionCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses.Protection),
    CommandClass_1.implementedVersion(2)
], ProtectionCC);
exports.ProtectionCC = ProtectionCC;
let ProtectionCCSet = class ProtectionCCSet extends ProtectionCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.local = options.local;
            this.rf = options.rf;
        }
    }
    serialize() {
        const payload = [this.local & 0b1111];
        if (this.version >= 2 && this.rf != undefined) {
            payload.push(this.rf & 0b1111);
        }
        this.payload = Buffer.from(payload);
        return super.serialize();
    }
    toLogEntry() {
        const message = {
            local: shared_1.getEnumMemberName(LocalProtectionState, this.local),
        };
        if (this.rf != undefined) {
            message.rf = shared_1.getEnumMemberName(RFProtectionState, this.rf);
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
ProtectionCCSet = __decorate([
    CommandClass_1.CCCommand(ProtectionCommand.Set)
], ProtectionCCSet);
exports.ProtectionCCSet = ProtectionCCSet;
let ProtectionCCReport = class ProtectionCCReport extends ProtectionCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this.local = this.payload[0] & 0b1111;
        if (this.payload.length >= 2) {
            this.rf = this.payload[1] & 0b1111;
        }
        this.persistValues();
    }
    toLogEntry() {
        const message = {
            local: shared_1.getEnumMemberName(LocalProtectionState, this.local),
        };
        if (this.rf != undefined) {
            message.rf = shared_1.getEnumMemberName(RFProtectionState, this.rf);
        }
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Number,
        label: "Local protection state",
        states: core_1.enumValuesToMetadataStates(LocalProtectionState),
    })
], ProtectionCCReport.prototype, "local", void 0);
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 }),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.Number,
        label: "RF protection state",
        states: core_1.enumValuesToMetadataStates(RFProtectionState),
    })
], ProtectionCCReport.prototype, "rf", void 0);
ProtectionCCReport = __decorate([
    CommandClass_1.CCCommand(ProtectionCommand.Report)
], ProtectionCCReport);
exports.ProtectionCCReport = ProtectionCCReport;
let ProtectionCCGet = class ProtectionCCGet extends ProtectionCC {
};
ProtectionCCGet = __decorate([
    CommandClass_1.CCCommand(ProtectionCommand.Get),
    CommandClass_1.expectedCCResponse(ProtectionCCReport)
], ProtectionCCGet);
exports.ProtectionCCGet = ProtectionCCGet;
let ProtectionCCSupportedReport = class ProtectionCCSupportedReport extends ProtectionCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 5);
        this.supportsTimeout = !!(this.payload[0] & 0b1);
        this.supportsExclusiveControl = !!(this.payload[0] & 0b10);
        this.supportedLocalStates = core_1.parseBitMask(this.payload.slice(1, 3), LocalProtectionState.Unprotected);
        this.supportedRFStates = core_1.parseBitMask(this.payload.slice(3, 5), RFProtectionState.Unprotected);
        this.persistValues();
    }
    persistValues() {
        if (!super.persistValues())
            return false;
        const valueDb = this.getValueDB();
        // update metadata (partially) for the local and rf values
        valueDb.setMetadata(getLocalStateValueID(this.endpointIndex), {
            ...core_1.ValueMetadata.Number,
            states: core_1.enumValuesToMetadataStates(LocalProtectionState, this.supportedLocalStates),
        });
        // update metadata (partially) for the local and rf values
        valueDb.setMetadata(getRFStateValueID(this.endpointIndex), {
            ...core_1.ValueMetadata.Number,
            states: core_1.enumValuesToMetadataStates(RFProtectionState, this.supportedRFStates),
        });
        return true;
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "supports exclusive control": this.supportsExclusiveControl,
                "supports timeout": this.supportsTimeout,
                "local protection states": this.supportedLocalStates
                    .map((local) => shared_1.getEnumMemberName(LocalProtectionState, local))
                    .map((str) => `\n· ${str}`)
                    .join(""),
                "RF protection states": this.supportedRFStates
                    .map((rf) => shared_1.getEnumMemberName(RFProtectionState, rf))
                    .map((str) => `\n· ${str}`)
                    .join(""),
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ internal: true })
], ProtectionCCSupportedReport.prototype, "supportsExclusiveControl", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], ProtectionCCSupportedReport.prototype, "supportsTimeout", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], ProtectionCCSupportedReport.prototype, "supportedLocalStates", void 0);
__decorate([
    CommandClass_1.ccValue({ internal: true })
], ProtectionCCSupportedReport.prototype, "supportedRFStates", void 0);
ProtectionCCSupportedReport = __decorate([
    CommandClass_1.CCCommand(ProtectionCommand.SupportedReport)
], ProtectionCCSupportedReport);
exports.ProtectionCCSupportedReport = ProtectionCCSupportedReport;
let ProtectionCCSupportedGet = class ProtectionCCSupportedGet extends ProtectionCC {
};
ProtectionCCSupportedGet = __decorate([
    CommandClass_1.CCCommand(ProtectionCommand.SupportedGet),
    CommandClass_1.expectedCCResponse(ProtectionCCSupportedReport)
], ProtectionCCSupportedGet);
exports.ProtectionCCSupportedGet = ProtectionCCSupportedGet;
let ProtectionCCExclusiveControlReport = class ProtectionCCExclusiveControlReport extends ProtectionCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this.exclusiveControlNodeId = this.payload[0];
        this.persistValues();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "exclusive control node id": this.exclusiveControlNodeId,
            },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 })
], ProtectionCCExclusiveControlReport.prototype, "exclusiveControlNodeId", void 0);
ProtectionCCExclusiveControlReport = __decorate([
    CommandClass_1.CCCommand(ProtectionCommand.ExclusiveControlReport)
], ProtectionCCExclusiveControlReport);
exports.ProtectionCCExclusiveControlReport = ProtectionCCExclusiveControlReport;
let ProtectionCCExclusiveControlGet = class ProtectionCCExclusiveControlGet extends ProtectionCC {
};
ProtectionCCExclusiveControlGet = __decorate([
    CommandClass_1.CCCommand(ProtectionCommand.ExclusiveControlGet),
    CommandClass_1.expectedCCResponse(ProtectionCCExclusiveControlReport)
], ProtectionCCExclusiveControlGet);
exports.ProtectionCCExclusiveControlGet = ProtectionCCExclusiveControlGet;
let ProtectionCCExclusiveControlSet = class ProtectionCCExclusiveControlSet extends ProtectionCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.exclusiveControlNodeId = options.exclusiveControlNodeId;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.exclusiveControlNodeId]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "exclusive control node id": this.exclusiveControlNodeId,
            },
        };
    }
};
ProtectionCCExclusiveControlSet = __decorate([
    CommandClass_1.CCCommand(ProtectionCommand.ExclusiveControlSet),
    CommandClass_1.expectedCCResponse(ProtectionCCReport)
], ProtectionCCExclusiveControlSet);
exports.ProtectionCCExclusiveControlSet = ProtectionCCExclusiveControlSet;
let ProtectionCCTimeoutReport = class ProtectionCCTimeoutReport extends ProtectionCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length >= 1);
        this.timeout = core_1.Timeout.parse(this.payload[0]);
        this.persistValues();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { timeout: this.timeout.toString() },
        };
    }
};
__decorate([
    CommandClass_1.ccValue({ minVersion: 2 })
], ProtectionCCTimeoutReport.prototype, "timeout", void 0);
ProtectionCCTimeoutReport = __decorate([
    CommandClass_1.CCCommand(ProtectionCommand.TimeoutReport)
], ProtectionCCTimeoutReport);
exports.ProtectionCCTimeoutReport = ProtectionCCTimeoutReport;
let ProtectionCCTimeoutGet = class ProtectionCCTimeoutGet extends ProtectionCC {
};
ProtectionCCTimeoutGet = __decorate([
    CommandClass_1.CCCommand(ProtectionCommand.TimeoutGet),
    CommandClass_1.expectedCCResponse(ProtectionCCTimeoutReport)
], ProtectionCCTimeoutGet);
exports.ProtectionCCTimeoutGet = ProtectionCCTimeoutGet;
let ProtectionCCTimeoutSet = class ProtectionCCTimeoutSet extends ProtectionCC {
    constructor(driver, options) {
        super(driver, options);
        if (CommandClass_1.gotDeserializationOptions(options)) {
            // TODO: Deserialize payload
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            this.timeout = options.timeout;
        }
    }
    serialize() {
        this.payload = Buffer.from([this.timeout.serialize()]);
        return super.serialize();
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { timeout: this.timeout.toString() },
        };
    }
};
ProtectionCCTimeoutSet = __decorate([
    CommandClass_1.CCCommand(ProtectionCommand.TimeoutSet),
    CommandClass_1.expectedCCResponse(ProtectionCCReport)
], ProtectionCCTimeoutSet);
exports.ProtectionCCTimeoutSet = ProtectionCCTimeoutSet;

//# sourceMappingURL=ProtectionCC.js.map
