/// <reference types="node" />
import type { Maybe } from "@zwave-js/core";
import { Duration, MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { PhysicalCCAPI } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum SupervisionCommand {
    Get = 1,
    Report = 2
}
/** @publicAPI */
export declare enum SupervisionStatus {
    NoSupport = 0,
    Working = 1,
    Fail = 2,
    Success = 255
}
/** @publicAPI */
export interface SupervisionResult {
    status: SupervisionStatus;
    remainingDuration?: Duration;
}
/** Returns the next session ID to be used for supervision */
export declare function getNextSessionId(): number;
export declare class SupervisionCCAPI extends PhysicalCCAPI {
    supportsCommand(cmd: SupervisionCommand): Maybe<boolean>;
    sendEncapsulated(encapsulated: CommandClass, requestStatusUpdates?: boolean): Promise<void>;
}
export declare class SupervisionCC extends CommandClass {
    ccCommand: SupervisionCommand;
    nodeId: number;
    /** Tests if a command should be supervised and thus requires encapsulation */
    static requiresEncapsulation(cc: CommandClass): boolean;
    /** Encapsulates a command that targets a specific endpoint */
    static encapsulate(driver: Driver, cc: CommandClass, requestStatusUpdates?: boolean): SupervisionCCGet;
}
declare type SupervisionCCReportOptions = CCCommandOptions & {
    moreUpdatesFollow: boolean;
    sessionId: number;
} & ({
    status: SupervisionStatus.Working;
    duration: Duration;
} | {
    status: SupervisionStatus.NoSupport | SupervisionStatus.Fail | SupervisionStatus.Success;
});
export declare class SupervisionCCReport extends SupervisionCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | SupervisionCCReportOptions);
    readonly moreUpdatesFollow: boolean;
    readonly sessionId: number;
    readonly status: SupervisionStatus;
    readonly duration: Duration | undefined;
    toLogEntry(): MessageOrCCLogEntry;
}
interface SupervisionCCGetOptions extends CCCommandOptions {
    requestStatusUpdates: boolean;
    encapsulated: CommandClass;
}
export declare class SupervisionCCGet extends SupervisionCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | SupervisionCCGetOptions);
    requestStatusUpdates: boolean;
    sessionId: number;
    encapsulated: CommandClass;
    serialize(): Buffer;
    protected computeEncapsulationOverhead(): number;
    toLogEntry(): MessageOrCCLogEntry;
}
export {};
