"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThermostatFanStateCCGet = exports.ThermostatFanStateCCReport = exports.ThermostatFanStateCC = exports.ThermostatFanStateCCAPI = exports.ThermostatFanState = exports.ThermostatFanStateCommand = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const API_1 = require("./API");
const CommandClass_1 = require("./CommandClass");
// All the supported commands
var ThermostatFanStateCommand;
(function (ThermostatFanStateCommand) {
    ThermostatFanStateCommand[ThermostatFanStateCommand["Get"] = 2] = "Get";
    ThermostatFanStateCommand[ThermostatFanStateCommand["Report"] = 3] = "Report";
})(ThermostatFanStateCommand = exports.ThermostatFanStateCommand || (exports.ThermostatFanStateCommand = {}));
var ThermostatFanState;
(function (ThermostatFanState) {
    ThermostatFanState[ThermostatFanState["Idle / off"] = 0] = "Idle / off";
    ThermostatFanState[ThermostatFanState["Running / running low"] = 1] = "Running / running low";
    ThermostatFanState[ThermostatFanState["Running high"] = 2] = "Running high";
    ThermostatFanState[ThermostatFanState["Running medium"] = 3] = "Running medium";
    ThermostatFanState[ThermostatFanState["Circulation mode"] = 4] = "Circulation mode";
    ThermostatFanState[ThermostatFanState["Humidity circulation mode"] = 5] = "Humidity circulation mode";
    ThermostatFanState[ThermostatFanState["Right - left circulation mode"] = 6] = "Right - left circulation mode";
    ThermostatFanState[ThermostatFanState["Up - down circulation mode"] = 7] = "Up - down circulation mode";
    ThermostatFanState[ThermostatFanState["Quiet circulation mode"] = 8] = "Quiet circulation mode";
})(ThermostatFanState = exports.ThermostatFanState || (exports.ThermostatFanState = {}));
let ThermostatFanStateCCAPI = class ThermostatFanStateCCAPI extends API_1.CCAPI {
    constructor() {
        super(...arguments);
        this[_a] = async ({ property, }) => {
            switch (property) {
                case "state":
                    return this.get();
                default:
                    API_1.throwUnsupportedProperty(this.ccId, property);
            }
        };
    }
    supportsCommand(cmd) {
        switch (cmd) {
            case ThermostatFanStateCommand.Get:
                return this.isSinglecast();
        }
        return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
        this.assertSupportsCommand(ThermostatFanStateCommand, ThermostatFanStateCommand.Get);
        const cc = new ThermostatFanStateCCGet(this.driver, {
            nodeId: this.endpoint.nodeId,
            endpoint: this.endpoint.index,
        });
        const response = await this.driver.sendCommand(cc, this.commandOptions);
        if (response) {
            return response === null || response === void 0 ? void 0 : response.state;
        }
    }
};
_a = API_1.POLL_VALUE;
ThermostatFanStateCCAPI = __decorate([
    CommandClass_1.API(core_1.CommandClasses["Thermostat Fan State"])
], ThermostatFanStateCCAPI);
exports.ThermostatFanStateCCAPI = ThermostatFanStateCCAPI;
let ThermostatFanStateCC = class ThermostatFanStateCC extends CommandClass_1.CommandClass {
    async interview(complete = true) {
        const node = this.getNode();
        const endpoint = this.getEndpoint();
        const api = endpoint.commandClasses["Thermostat Fan State"].withOptions({
            priority: Constants_1.MessagePriority.NodeQuery,
        });
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: doing a ${complete ? "complete" : "partial"} interview...`,
            direction: "none",
        });
        // Always query the actual status
        this.driver.controllerLog.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "querying current thermostat fan state...",
            direction: "outbound",
        });
        const currentStatus = await api.get();
        if (currentStatus) {
            this.driver.controllerLog.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: "received current thermostat fan state: " +
                    shared_1.getEnumMemberName(ThermostatFanState, currentStatus),
                direction: "inbound",
            });
        }
        // Remember that the interview is complete
        this.interviewComplete = true;
    }
};
ThermostatFanStateCC = __decorate([
    CommandClass_1.commandClass(core_1.CommandClasses["Thermostat Fan State"]),
    CommandClass_1.implementedVersion(2)
], ThermostatFanStateCC);
exports.ThermostatFanStateCC = ThermostatFanStateCC;
let ThermostatFanStateCCReport = class ThermostatFanStateCCReport extends ThermostatFanStateCC {
    constructor(driver, options) {
        super(driver, options);
        core_1.validatePayload(this.payload.length == 1);
        this._state = this.payload[0] & 0b1111;
        this.persistValues();
    }
    get state() {
        return this._state;
    }
    toLogEntry() {
        const message = {
            state: shared_1.getEnumMemberName(ThermostatFanState, this.state),
        };
        return {
            ...super.toLogEntry(),
            message,
        };
    }
};
__decorate([
    CommandClass_1.ccValue(),
    CommandClass_1.ccValueMetadata({
        ...core_1.ValueMetadata.ReadOnlyUInt8,
        states: core_1.enumValuesToMetadataStates(ThermostatFanState),
        label: "Thermostat fan state",
    })
], ThermostatFanStateCCReport.prototype, "state", null);
ThermostatFanStateCCReport = __decorate([
    CommandClass_1.CCCommand(ThermostatFanStateCommand.Report)
], ThermostatFanStateCCReport);
exports.ThermostatFanStateCCReport = ThermostatFanStateCCReport;
let ThermostatFanStateCCGet = class ThermostatFanStateCCGet extends ThermostatFanStateCC {
};
ThermostatFanStateCCGet = __decorate([
    CommandClass_1.CCCommand(ThermostatFanStateCommand.Get),
    CommandClass_1.expectedCCResponse(ThermostatFanStateCCReport)
], ThermostatFanStateCCGet);
exports.ThermostatFanStateCCGet = ThermostatFanStateCCGet;

//# sourceMappingURL=ThermostatFanStateCC.js.map
