/// <reference types="node" />
import { DSTInfo, Maybe, MessageOrCCLogEntry } from "@zwave-js/core";
import type { Driver } from "../driver/Driver";
import { CCAPI } from "./API";
import { CCCommandOptions, CommandClass, CommandClassDeserializationOptions } from "./CommandClass";
export declare enum TimeCommand {
    TimeGet = 1,
    TimeReport = 2,
    DateGet = 3,
    DateReport = 4,
    TimeOffsetSet = 5,
    TimeOffsetGet = 6,
    TimeOffsetReport = 7
}
export declare class TimeCCAPI extends CCAPI {
    supportsCommand(cmd: TimeCommand): Maybe<boolean>;
    getTime(): Promise<Pick<TimeCCTimeReport, "hour" | "minute" | "second"> | undefined>;
    getDate(): Promise<Pick<TimeCCDateReport, "day" | "month" | "year"> | undefined>;
    setTimezone(timezone: DSTInfo): Promise<void>;
    getTimezone(): Promise<DSTInfo | undefined>;
}
export declare class TimeCC extends CommandClass {
    ccCommand: TimeCommand;
    interview(complete?: boolean): Promise<void>;
}
interface TimeCCTimeReportOptions extends CCCommandOptions {
    hour: number;
    minute: number;
    second: number;
}
export declare class TimeCCTimeReport extends TimeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | TimeCCTimeReportOptions);
    hour: number;
    minute: number;
    second: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class TimeCCTimeGet extends TimeCC {
}
interface TimeCCDateReportOptions extends CCCommandOptions {
    year: number;
    month: number;
    day: number;
}
export declare class TimeCCDateReport extends TimeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | TimeCCDateReportOptions);
    year: number;
    month: number;
    day: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class TimeCCDateGet extends TimeCC {
}
interface TimeCCTimeOffsetSetOptions extends CCCommandOptions {
    standardOffset: number;
    dstOffset: number;
    dstStart: Date;
    dstEnd: Date;
}
export declare class TimeCCTimeOffsetSet extends TimeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | TimeCCTimeOffsetSetOptions);
    standardOffset: number;
    dstOffset: number;
    dstStartDate: Date;
    dstEndDate: Date;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class TimeCCTimeOffsetReport extends TimeCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    private _standardOffset;
    get standardOffset(): number;
    private _dstOffset;
    get dstOffset(): number;
    private _dstStartDate;
    get dstStartDate(): Date;
    private _dstEndDate;
    get dstEndDate(): Date;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class TimeCCTimeOffsetGet extends TimeCC {
}
export {};
