/// <reference types="node" />
import { Maybe, MessageOrCCLogEntry, ValueID, ValueMetadata } from "@zwave-js/core";
import type { Driver } from "../../driver/Driver";
import { CCCommandOptions, CommandClassDeserializationOptions } from "../CommandClass";
import { ManufacturerProprietaryCC } from "../ManufacturerProprietaryCC";
/** Returns the ValueID used to store the current venetian blind position */
export declare function getFibaroVenetianBlindPositionValueId(endpoint: number): ValueID;
/** Returns the value metadata for venetian blind position */
export declare function getFibaroVenetianBlindPositionMetadata(): ValueMetadata;
/** Returns the ValueID used to store the current venetian blind tilt */
export declare function getFibaroVenetianBlindTiltValueId(endpoint: number): ValueID;
/** Returns the value metadata for venetian blind tilt */
export declare function getFibaroVenetianBlindTiltMetadata(): ValueMetadata;
export declare enum FibaroCCIDs {
    VenetianBlind = 38
}
export declare class FibaroCC extends ManufacturerProprietaryCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | CCCommandOptions);
    fibaroCCId: number;
    fibaroCCCommand: number;
    serialize(): Buffer;
}
export declare enum FibaroVenetianBlindCCCommand {
    Set = 1,
    Get = 2,
    Report = 3
}
export declare class FibaroVenetianBlindCC extends FibaroCC {
    fibaroCCCommand: FibaroVenetianBlindCCCommand;
    constructor(driver: Driver, options: CommandClassDeserializationOptions | CCCommandOptions);
    interview(complete?: boolean): Promise<void>;
}
export declare type FibaroVenetianBlindCCSetOptions = CCCommandOptions & ({
    position: number;
} | {
    tilt: number;
} | {
    position: number;
    tilt: number;
});
export declare class FibaroVenetianBlindCCSet extends FibaroVenetianBlindCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | FibaroVenetianBlindCCSetOptions);
    position: number | undefined;
    tilt: number | undefined;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class FibaroVenetianBlindCCReport extends FibaroVenetianBlindCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions);
    readonly position?: Maybe<number>;
    readonly tilt?: Maybe<number>;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class FibaroVenetianBlindCCGet extends FibaroVenetianBlindCC {
    constructor(driver: Driver, options: CommandClassDeserializationOptions | CCCommandOptions);
}
