"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssignReturnRouteRequestTransmitReport = exports.AssignReturnRouteResponse = exports.AssignReturnRouteRequest = exports.AssignReturnRouteRequestBase = void 0;
const core_1 = require("@zwave-js/core");
const shared_1 = require("@zwave-js/shared");
const Constants_1 = require("../message/Constants");
const Message_1 = require("../message/Message");
const SendDataMessages_1 = require("./SendDataMessages");
let AssignReturnRouteRequestBase = class AssignReturnRouteRequestBase extends Message_1.Message {
    constructor(driver, options) {
        if (Message_1.gotDeserializationOptions(options) &&
            (new.target) !== AssignReturnRouteRequestTransmitReport) {
            return new AssignReturnRouteRequestTransmitReport(driver, options);
        }
        super(driver, options);
    }
};
AssignReturnRouteRequestBase = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Request, Constants_1.FunctionType.AssignReturnRoute),
    Message_1.priority(Constants_1.MessagePriority.NodeQuery)
], AssignReturnRouteRequestBase);
exports.AssignReturnRouteRequestBase = AssignReturnRouteRequestBase;
let AssignReturnRouteRequest = class AssignReturnRouteRequest extends AssignReturnRouteRequestBase {
    constructor(driver, options) {
        super(driver, options);
        if (Message_1.gotDeserializationOptions(options)) {
            throw new core_1.ZWaveError(`${this.constructor.name}: deserialization not implemented`, core_1.ZWaveErrorCodes.Deserialization_NotImplemented);
        }
        else {
            if (options.nodeId === options.destinationNodeId) {
                throw new core_1.ZWaveError(`The source and destination node must not be identical`, core_1.ZWaveErrorCodes.Argument_Invalid);
            }
            this.nodeId = options.nodeId;
            this.destinationNodeId = options.destinationNodeId;
        }
    }
    serialize() {
        this.payload = Buffer.from([
            this.nodeId,
            this.destinationNodeId,
            this.callbackId,
        ]);
        return super.serialize();
    }
};
AssignReturnRouteRequest = __decorate([
    Message_1.expectedResponse(Constants_1.FunctionType.AssignReturnRoute),
    Message_1.expectedCallback(Constants_1.FunctionType.AssignReturnRoute)
], AssignReturnRouteRequest);
exports.AssignReturnRouteRequest = AssignReturnRouteRequest;
let AssignReturnRouteResponse = class AssignReturnRouteResponse extends Message_1.Message {
    constructor(driver, options) {
        super(driver, options);
        this.hasStarted = this.payload[0] !== 0;
    }
    isOK() {
        return this.hasStarted;
    }
    toJSON() {
        return super.toJSONInherited({
            hasStarted: this.hasStarted,
        });
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: { "has started": this.hasStarted },
        };
    }
};
AssignReturnRouteResponse = __decorate([
    Message_1.messageTypes(Constants_1.MessageType.Response, Constants_1.FunctionType.AssignReturnRoute)
], AssignReturnRouteResponse);
exports.AssignReturnRouteResponse = AssignReturnRouteResponse;
class AssignReturnRouteRequestTransmitReport extends AssignReturnRouteRequestBase {
    constructor(driver, options) {
        super(driver, options);
        this.callbackId = this.payload[0];
        this._transmitStatus = this.payload[1];
    }
    isOK() {
        return this._transmitStatus === SendDataMessages_1.TransmitStatus.OK;
    }
    get transmitStatus() {
        return this._transmitStatus;
    }
    toJSON() {
        return super.toJSONInherited({
            callbackId: this.callbackId,
            transmitStatus: this.transmitStatus,
        });
    }
    toLogEntry() {
        return {
            ...super.toLogEntry(),
            message: {
                "callback id": this.callbackId,
                "transmit status": shared_1.getEnumMemberName(SendDataMessages_1.TransmitStatus, this.transmitStatus),
            },
        };
    }
}
exports.AssignReturnRouteRequestTransmitReport = AssignReturnRouteRequestTransmitReport;

//# sourceMappingURL=AssignReturnRouteMessages.js.map
