import { MessageOrCCLogEntry } from "@zwave-js/core";
import { SinglecastCC } from "../commandclass/CommandClass";
import type { ICommandClassContainer } from "../commandclass/ICommandClassContainer";
import type { Driver } from "../driver/Driver";
import { Message, MessageDeserializationOptions } from "../message/Message";
export declare enum RSSIValue {
    NotAvailable = 127,
    ReceiverSaturated = 126,
    NoSignalDetected = 125
}
export declare class BridgeApplicationCommandRequest extends Message implements ICommandClassContainer {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    readonly routedBusy: boolean;
    readonly frameType: "singlecast" | "broadcast" | "multicast";
    readonly targetNodeId: number | number[];
    readonly isExploreFrame: boolean;
    readonly isForeignFrame: boolean;
    readonly fromForeignHomeId: boolean;
    readonly rssi: number | RSSIValue;
    command: SinglecastCC;
    toLogEntry(): MessageOrCCLogEntry;
}
