import { DataDirection, ValueAddedArgs, ValueID, ValueNotificationArgs, ValueRemovedArgs, ValueUpdatedArgs, ZWaveLogContainer, ZWaveLoggerBase } from "@zwave-js/core";
import type { ZWaveNode } from "../node/Node";
export declare const CONTROLLER_LABEL = "CNTRLR";
interface LogNodeOptions {
    message: string;
    level?: "warn" | "error";
    direction?: DataDirection;
    endpoint?: number;
}
export declare type LogValueArgs<T> = T & {
    nodeId: number;
    internal?: boolean;
};
export declare class ControllerLogger extends ZWaveLoggerBase {
    constructor(loggers: ZWaveLogContainer);
    private _isValueLogVisible;
    private isValueLogVisible;
    private _isControllerLogVisible;
    private isControllerLogVisible;
    /**
     * Logs a message
     * @param msg The message to output
     */
    print(message: string, level?: "warn" | "error"): void;
    /**
     * Logs a node-related message with the correct prefix
     * @param message The message to output
     * @param level The optional loglevel if it should be different from "info"
     */
    logNode(nodeId: number, message: string, level?: "warn" | "error"): void;
    /**
     * Logs a node-related message with the correct prefix
     * @param node The node to log the message for
     * @param options The message and other options
     */
    logNode(nodeId: number, options: LogNodeOptions): void;
    valueEventPrefixes: Readonly<{
        added: string;
        updated: string;
        removed: string;
        notification: string;
    }>;
    private formatValue;
    /** Prints a log message for an added, updated or removed value */
    value(change: "added", args: LogValueArgs<ValueAddedArgs>): void;
    value(change: "updated", args: LogValueArgs<ValueUpdatedArgs>): void;
    value(change: "removed", args: LogValueArgs<ValueRemovedArgs>): void;
    value(change: "notification", args: LogValueArgs<ValueNotificationArgs>): void;
    /** Prints a log message for updated metadata of a value id */
    metadataUpdated(args: LogValueArgs<ValueID>): void;
    /** Logs the interview progress of a node */
    interviewStage(node: ZWaveNode): void;
    /** Logs the interview progress of a node */
    interviewStart(node: ZWaveNode): void;
}
export {};
