/// <reference types="node" />
import type { JSONObject } from "@zwave-js/shared";
import type { Driver } from "../driver/Driver";
import { Message, MessageBaseOptions, MessageDeserializationOptions } from "../message/Message";
import type { SuccessIndicator } from "../message/SuccessIndicator";
import type { INodeQuery } from "./INodeQuery";
interface RequestNodeInfoRequestOptions extends MessageBaseOptions {
    nodeId: number;
}
export declare class RequestNodeInfoResponse extends Message implements SuccessIndicator {
    constructor(driver: Driver, options: MessageDeserializationOptions);
    isOK(): boolean;
    private _wasSent;
    get wasSent(): boolean;
    private _errorCode;
    get errorCode(): number | undefined;
    toJSON(): JSONObject;
}
export declare class RequestNodeInfoRequest extends Message implements INodeQuery {
    constructor(driver: Driver, options: RequestNodeInfoRequestOptions);
    nodeId: number;
    needsCallbackId(): boolean;
    serialize(): Buffer;
    toJSON(): JSONObject;
}
export {};
