"use strict";
/* wotan-disable no-restricted-property-access */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAndStartDriver = exports.PORT_ADDRESS = void 0;
const serial_1 = require("@zwave-js/serial");
const Driver_1 = require("../driver/Driver");
// load the driver with stubbed out Serialport
jest.mock("@zwave-js/serial", () => {
    const mdl = jest.requireActual("@zwave-js/serial");
    return {
        ...mdl,
        ZWaveSerialPort: mdl.MockSerialPort,
    };
});
exports.PORT_ADDRESS = "/tty/FAKE";
/** Creates a real driver instance with a mocked serial port to enable end to end tests */
// eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
async function createAndStartDriver(options = {}) {
    // Usually we don't want logs in these tests
    if (!options.logConfig) {
        options.logConfig = {
            enabled: false,
        };
    }
    const driver = new Driver_1.Driver(exports.PORT_ADDRESS, {
        ...options,
        skipInterview: true,
    });
    driver.on("error", () => {
        /* swallow error events during testing */
    });
    await driver.start();
    const portInstance = serial_1.MockSerialPort.getInstance(exports.PORT_ADDRESS);
    portInstance.openStub.mockClear();
    portInstance.closeStub.mockClear();
    portInstance.writeStub.mockClear();
    portInstance["_lastWrite"] = undefined;
    // Mock the value DB, because the original one will not be initialized
    // with skipInterview: true
    driver["_valueDB"] = new Map();
    driver["_valueDB"].close = () => Promise.resolve();
    driver["_metadataDB"] = new Map();
    driver["_metadataDB"].close = () => Promise.resolve();
    // Mock the controller as it will not be initialized with skipInterview: true
    driver["_controller"] = {
        ownNodeId: 1,
        isFunctionSupported: () => true,
        nodes: new Map(),
    };
    return {
        driver,
        serialport: portInstance,
    };
}
exports.createAndStartDriver = createAndStartDriver;

//# sourceMappingURL=utils.js.map
